﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Spire.Doc;
using Spire.Doc.Documents;
using Spire.Doc.Fields;
using System.Drawing;

namespace SetBackgroundColor
{
    class Program
    {
        static void Main(string[] args)
        {
            Document document = new Document();
            document.LoadFromFile(@"input.docx");
            Paragraph paragaph = document.Sections[0].Paragraphs[1];

            //Set background color for the paragraph
            paragaph.Format.BackColor = Color.LightGray;

            //Set background color for the selected text of paragraph
            paragaph = document.Sections[0].Paragraphs[3];
            TextSelection selection= paragaph.Find("Spire.Doc",true,false);
            TextRange range = selection.GetAsOneRange();
            range.CharacterFormat.TextBackgroundColor = Color.Yellow;

            document.SaveToFile("output.docx",FileFormat.Docx);
        }
    }
}
